/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.audio;

import java.util.HashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class AudioPlayer {
    public static final double MUSIC = 0.0;
    public static final double SFX = 1.0;
    private static HashMap<String, Clip> clips;
    private static int gap;
    private static boolean mute;

    static {
        mute = false;
    }

    public static void init() {
        clips = new HashMap();
        gap = 0;
    }

    public static void load(String s, String n) {
        if (clips.get(n) != null) {
            return;
        }
        try {
            AudioInputStream ais = AudioSystem.getAudioInputStream(AudioPlayer.class.getResourceAsStream(s));
            AudioFormat baseFormat = ais.getFormat();
            AudioFormat decodeFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            AudioInputStream dais = AudioSystem.getAudioInputStream(decodeFormat, ais);
            Clip clip = AudioSystem.getClip();
            clip.open(dais);
            clips.put(n, clip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void play(String s, double type) {
        AudioPlayer.play(s, gap);
    }

    public static void play(String s, int i) {
        if (mute) {
            return;
        }
        Clip c = clips.get(s);
        if (c == null) {
            return;
        }
        if (c.isRunning()) {
            c.stop();
        }
        c.setFramePosition(i);
        while (!c.isRunning()) {
            c.start();
        }
    }

    public static void stop(String s) {
        if (clips.get(s) == null) {
            return;
        }
        if (clips.get(s).isRunning()) {
            clips.get(s).stop();
        }
    }

    public static void resume(String s, double type) {
        if (mute) {
            return;
        }
        if (clips.get(s).isRunning()) {
            return;
        }
        clips.get(s).start();
    }

    public static void loop(String s, double type) {
        AudioPlayer.loop(s, gap, gap, clips.get(s).getFrameLength() - 1);
    }

    public static void loop(String s, int frame) {
        AudioPlayer.loop(s, frame, gap, clips.get(s).getFrameLength() - 1);
    }

    public static void loop(String s, int start, int end) {
        AudioPlayer.loop(s, gap, start, end);
    }

    public static void loop(String s, int frame, int start, int end) {
        AudioPlayer.stop(s);
        if (mute) {
            return;
        }
        clips.get(s).setLoopPoints(start, end);
        clips.get(s).setFramePosition(frame);
        clips.get(s).loop(-1);
    }

    public static void setPosition(String s, int frame) {
        clips.get(s).setFramePosition(frame);
    }

    public static int getFrames(String s) {
        return clips.get(s).getFrameLength();
    }

    public static int getPosition(String s) {
        return clips.get(s).getFramePosition();
    }

    public static void close(String s) {
        AudioPlayer.stop(s);
        clips.get(s).close();
    }
}

